#ifndef GST_CU_COLOR_SCHEME_HPP_
#define GST_CU_COLOR_SCHEME_HPP_

#include "buildspec.h"

#include "Utils/Color.h"

#include <cstdint>
#include <string>
#include <vector>

#include <boost/shared_ptr.hpp>

namespace GST
{
namespace ClientUtils
{
struct ContinuousColorMap;
struct DiscreteColorMap;
class DynamicContinousScale;
class DynamicDiscreteScale;

enum class ColorSchemeKind
{
	Discrete,
	Continuous,
};

class GST_API_EXPORT ColorScheme
{
public:
	ColorScheme(int64_t id, std::string name);
	virtual ~ColorScheme()
	{
	}
	virtual ColorSchemeKind kind() const = 0;
	int64_t id() const;
	const std::string &name() const;

private:
	int64_t m_id;
	std::string m_name;
};
using ColorSchemePtr = boost::shared_ptr<ColorScheme>;
using ColorSchemeList = std::vector<ColorSchemePtr>;

class GST_API_EXPORT DiscreteColorScheme : public ColorScheme
{
public:
	DiscreteColorScheme(int64_t id,
						std::string name,
						std::vector<Utils::ColorRGB> colors);
	ColorSchemeKind kind() const override;
	const std::vector<Utils::ColorRGB> &colors() const;

private:
	std::vector<Utils::ColorRGB> m_colors;
};

class GST_API_EXPORT ContinuousColorSchemeValue
{
public:
	ContinuousColorSchemeValue(Utils::ColorRGB color, double stop);
	Utils::ColorRGB color() const;
	double stop() const;
	bool operator==(const ContinuousColorSchemeValue &other) const;

private:
	Utils::ColorRGB m_color;
	double m_stop;
};

class GST_API_EXPORT ContinuousColorScheme : public ColorScheme
{
public:
	ContinuousColorScheme(int64_t id,
						  std::string name,
						  std::vector<ContinuousColorSchemeValue> values);
	ColorSchemeKind kind() const override;
	const std::vector<ContinuousColorSchemeValue> &values() const;

private:
	std::vector<ContinuousColorSchemeValue> m_values;
};

GST_API_EXPORT std::vector<ContinuousColorSchemeValue>
ColorSchemeValuesFromColorMap(const ContinuousColorMap &map);
GST_API_EXPORT std::vector<Utils::ColorRGB> ColorSchemeValuesFromColorMap(
	const DiscreteColorMap &map);
GST_API_EXPORT std::vector<ContinuousColorSchemeValue>
ColorSchemeValuesFromDynamicColorScale(DynamicContinousScale &map);
GST_API_EXPORT std::vector<Utils::ColorRGB>
ColorSchemeValuesFromDynamicColorScale(DynamicDiscreteScale &map);
} // namespace ClientUtils
} // namespace GST

#endif // GST_CU_COLOR_SCHEME_HPP_
